import UIKit

class ViewController: UIViewController, UIScrollViewDelegate
{
    @IBOutlet weak var myScrollView: UIScrollView!
    @IBOutlet weak var myPageController: UIPageControl!
    @IBOutlet weak var myContentView: UIView!
    @IBOutlet weak var widthConstraint: NSLayoutConstraint!
    
    let numOfPages = 4
    var width : CGFloat!
    
    var redView : UIView!
    var greenView : UIView!
    var animating = false
    
    override func viewWillAppear(_ animated: Bool)
    {
        super.viewWillAppear(true)
        width = myScrollView.bounds.width
        widthConstraint.constant = width * CGFloat (numOfPages)
        myPageController.currentPage = 0
        myPageController.numberOfPages = numOfPages
        
        redView.frame = CGRect(origin: CGPoint(x: width * 1,
                                               y: 0.0),
                               size: CGSize(width: width,
                                            height: width))
        
        greenView.frame = CGRect(origin: CGPoint(x: width * 3,
                                               y: 0.0),
                               size: CGSize(width: width,
                                            height: width))
    }
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
        redView = UIView(frame: CGRect.zero)
        redView.backgroundColor = UIColor.red
        myContentView.addSubview(redView)
        
        greenView = UIView(frame: CGRect.zero)
        greenView.backgroundColor = UIColor.green
        myContentView.addSubview(greenView)
        
        myScrollView.delegate = self
        
        myPageController.addTarget(self,
                                   action: #selector(paged),
                                   for: UIControl.Event.valueChanged)
    }
    
    
    @objc func paged(sender: UIPageControl) -> Void
    {
        animating = true
        let nextPage = sender.currentPage
        let newFrame = CGRect(origin: CGPoint(x: CGFloat(nextPage) * width,
                                              y: 0.0),
                              size: CGSize(width: width,
                                           height: width))
        
        myScrollView.scrollRectToVisible(newFrame,
                                         animated: true)
    }
    
    func scrollViewDidEndScrollingAnimation(_ scrollView: UIScrollView)
    {
        animating = false
    }
    

    func scrollViewDidScroll(_ scrollView: UIScrollView)
    {
        if ( !animating )
        {
            let xOrig = myScrollView.contentOffset.x
            
            let nextPage : Int = Int( round( xOrig / width) )
            myPageController.currentPage = nextPage
        }
    }
    
    

}

